
	uniform mat4 objToWorld;
	varying vec4 diffuse,ambient;
	varying vec3 normal,lightDir,halfVector;
	
	void main()
	{	

		gl_Position = ftransform();

normal = normalize(gl_NormalMatrix * gl_Normal);
lightDir = vec3(gl_LightSource[0].position);


halfVector = gl_LightSource[0].halfVector.xyz;
gl_TexCoord[0] = gl_MultiTexCoord0;
vec4 world_position=objToWorld*gl_Vertex;

gl_TexCoord[1].s = (world_position.x/200.0)+0.5;
gl_TexCoord[1].t = (world_position.z/200.0)+0.5;



	vec3 u = normalize( vec3(gl_ModelViewMatrix * gl_Vertex) );
	vec3 n = normalize( gl_NormalMatrix * gl_Normal );
	vec3 r = reflect( u, n );
	float m = 2.0 * sqrt( r.x*r.x + r.y*r.y + (r.z+1.0)*(r.z+1.0) );
	gl_TexCoord[2].s = r.x/m + 0.5;
	gl_TexCoord[2].t = r.y/m + 0.5;



	} 